       >> IMP MARGIN-R IS END
       identification division.
       program-id.  "EncodeUSPSBarcode".
       data division.
       working-storage section.

       01  ARGUMENT-DESCRIPTION        BINARY(2).
           02  ARGUMENT-TYPE           PIC 9(2).
               88  ARGUMENT-IS-OMITTED VALUE 32.
           02  ARGUMENT-LENGTH         PIC 9(8) BINARY(4).
           02  ARGUMENT-DIGIT-COUNT    PIC 9(2).
           02  ARGUMENT-SCALE          PIC S9(2).

       01  C-CARG-SUCCESS              PIC X.
           88  IS-C-CARG-SUCCESS       VALUE "Y".

       01  argument-lengths        binary(1).
           02  barcode-identifier-length      pic 999.
           02  service-type-identifier-length pic 999.
           02  mailer-identifier-length       pic 999.
           02  serial-number-length           pic 999.
           02  ZIP-code-length                pic 999.

       01  pic x.  88  argument-error-occurred value "T" false "F".

       01  routing-code-conversion     pic 9(30) binary(13).
       01  routing-group redefines routing-code-conversion.
           02  routing-octet           pic 999 binary(1) occurs 13.

       01  tracking-code-conversion    pic 9(30) binary(13).
       01  redefines tracking-code-conversion.
           02  tracking-octet          pic 999 binary(1) occurs 13.

       01  addition-result             pic 99999 binary(2).
       01  redefines addition-result.
           02  addition-carry          pic 999 binary(1).
           02  addition-octet          pic 999 binary(1).

       01  carry-value                 pic 999 binary(1).

       01  an-integer                  pic 9(18).

       01  tracking-code-assembly      pic 9(18).

       01  crc11-fcs                   pic 9(5) binary(2).
       01  test-result                 pic 9(5) binary(2).

       01  i                           pic 9(5) binary(2).


       01  codewords.
           02  codeword                pic 9(4) binary(2)
                                       occurs 10 indexed by codeword-inx.
       01  codeword-divisor            pic 9(4) binary(2).

       01  character-table.
           02  char                    pic 9(4) binary(2)
                                       occurs 10 indexed by char-inx.

       01  character-bit-table binary(1).
           02  occurs 10 indexed by cbt-char.
               03  bit-value pic 9 occurs 13 indexed by cbt-bit.
               *> note: LSB is bit-value (n, 1)
               *>       USB is bit-value (n, 13)

       01  5-of-13.
           copy "FiveOf13.cpy".
       01  redefines 5-of-13.
           05  Table-I-Appendix-E      pic 9(5) binary(2)
                                       occurs 1287.
       01  2-of-13.
           copy "TwoOf13.cpy".
       01  redefines 2-of-13.
           05  Table-II-Appendix-E     pic 9(5) binary(2)
                                       occurs 78.
       01  bar-to-char-table binary(1).
           copy "BarToChar.cpy".
       01  redefines bar-to-char-table binary(1).
           02  occurs 65 indexed by bar-number.
               03  descender-char      pic 99.
               03  descender-bit       pic 99.
               03  ascender-char       pic 99.
               03  ascender-bit        pic 99.
       
       linkage section.
       01  barcode-identifier      pic XX.
       01  redefines barcode-identifier.
           02  barcode-identifier-left  pic 9.
           02  barcode-identifier-right pic 9. 
               88 is-valid-barcode-identifier values 0 thru 4.    

       01  service-type-identifier pic XXX.

       01  mailer-identifier       pic x(9).
           
       01  serial-number           pic x(9).

       01  delivery-point-ZIP-code pic x(11).

       01  bar-code                pic x(65).

       procedure division using barcode-identifier
                                service-type-identifier
                                mailer-identifier
                                serial-number
                                delivery-point-ZIP-code
                         giving bar-code.
       a.
           set argument-error-occurred to false.
           perform decode-input-arguments.
           if argument-error-occurred
               display "One or more argument errors "
                       "on call to EncodeUSPSBarcode."
               go error-exit
           end-if.
           perform confirm-input-argument-lengths.
           if argument-error-occurred
               display "One or more argument errors "
                       "on call to EncodeUSPSBarcode."
               go error-exit
           end-if.
           perform confirm-input-arguments-numeric.
           if argument-error-occurred
               display "One or more argument errors "
                       "on call to EncodeUSPSBarcode."
               go error-exit
           end-if.
           move service-type-identifier to tracking-code-assembly (1:3).
           if mailer-identifier-length = 6
               move mailer-identifier (1:6) to tracking-code-assembly (4:6)
               move serial-number (1:9) to tracking-code-assembly (10:9)
           else
               move mailer-identifier (1:9) to tracking-code-assembly (4:9)
               move serial-number (1:6) to tracking-code-assembly (13:6)
           end-if.
           evaluate ZIP-code-length
           when 9
                   move delivery-point-ZIP-code (1: 9) to an-integer
                   add 100001, an-integer giving routing-code-conversion
           when 5
                   move delivery-point-ZIP-code (1: 5) to an-integer
                   add 1, an-integer giving routing-code-conversion
           when 11
                   move delivery-point-ZIP-code (1: 11) to an-integer
                   add 1000100001, an-integer giving routing-code-conversion
           when other
                   move 0 to routing-code-conversion
           end-evaluate.
           multiply 10 by routing-code-conversion.
           add barcode-identifier-left to routing-code-conversion. 
           multiply 5 by routing-code-conversion.
           add barcode-identifier-right to routing-code-conversion.
      *       The following steps require 31+ decimal digits of precision,
      *       104 binary digits (bits).   The multiplication by
      *       1,000,000,000,000,000,000 will overflow the limit of 30 decimal
      *       digits, so we must resort to extended precision binary arithmetic.
      *
      *       The first issue is to note:
      *           1,000,000,000,000,000,000 = 62,500,000,000,000,000 * 16
      *       Multiplication by 16 will be accomplished by left shift 4 bits
      *           using a group item to avoid truncation).
           multiply 62500000000000000 by routing-code-conversion.
           call "C$LogicalShiftLeft" using routing-group, 4 
      *
      *    now use extended precision base 256 arithmetic to simulate:                     
      *    add tracking-code-assembly to routing-code-conversion.
           move tracking-code-assembly to tracking-code-conversion.
           move 0 to carry-value.
           perform varying i from 13 by -1 until i < 1
               add carry-value, routing-octet (i), tracking-octet (i)
                   giving addition-result
               move addition-octet to routing-octet (i)
               move addition-carry to carry-value
           end-perform.
      D    display "Binary data: "
      D    call "DisplayHex" using routing-code-conversion, "XX".

           call "USPS_MSB_Math_CRC11GenerateFCS" using routing-code-conversion
                                                giving crc11-fcs.

           *> convert to codewords

           move 636 to codeword-divisor.                
           perform varying codeword-inx from count of codeword by -1
                     until codeword-inx = 1
               divide codeword-divisor into routing-code-conversion
                                     giving routing-code-conversion
                                  remainder codeword (codeword-inx)
               set an-integer to codeword-inx
               *> display an-integer convert, codeword (codeword-inx) convert
               move 1365 to codeword-divisor
           end-perform.
           move routing-code-conversion to codeword (1).
           *> display "1          ", codeword (1) convert.

           *>  Step 4:  Modify Codeword J and Codeword A
           multiply 2 by codeword (count of codeword).
           move 1024 to test-result.
           call "C$LogicalAnd" using test-result, crc11-fcs.
           if test-result not = 0
               add 659 to codeword (1)
           end-if.
           *> perform varying codeword-inx from 1 by 1
           *>           until codeword-inx > count of codeword
           *>     set an-integer to codeword-inx
           *>     display an-integer convert, codeword (codeword-inx) convert
           *> end-perform.
           move all x"01" to character-bit-table.
           perform varying codeword-inx from 1 by 1
                     until codeword-inx > count of codeword
               set char-inx to codeword-inx
               move codeword (codeword-inx) to i
               if i < 1287
                   add 1 to i
                   move Table-I-Appendix-E (i) to char (char-inx)
               else
                   subtract 1286 from i
                   move Table-II-Appendix-E (i) to char (char-inx)
               end-if
               move 1 to test-result
               call "C$LogicalAnd" using test-result, crc11-fcs
               if test-result not = 0
                   move 8191 to test-result
                   call "C$LogicalXor" using char (char-inx), test-result
                   move 8191 to test-result
                   call "C$LogicalAnd" using char (char-inx), test-result
               end-if
               call "C$LogicalShiftRight" using crc11-fcs

               move char (char-inx) to test-result
               set cbt-char to char-inx
               perform varying cbt-bit from 1 by 1 
                         until cbt-bit > count of bit-value
                   call "C$LogicalAnd" using bit-value (cbt-char, cbt-bit), test-result
                   call "C$LogicalShiftRight" using test-result
               end-perform
           end-perform.
      D    display "Characters: "
      D    call "DisplayHex" using character-table, "XXXX"

           perform varying bar-number from 1 by 1 
                     until bar-number > length of bar-code
               set i to bar-number
               set cbt-char to descender-char (bar-number)
               set cbt-bit  to descender-bit  (bar-number)
               if bit-value (cbt-char, cbt-bit) = 0
                   set cbt-char to ascender-char (bar-number)
                   set cbt-bit  to ascender-bit  (bar-number)
                   if bit-value (cbt-char, cbt-bit) = 0
                       move "T" to bar-code (i:1)     *> neither
                   else
                       move "A" to bar-code (i:1)     *> ascender only
                   end-if 
               else
                   set cbt-char to ascender-char (bar-number)
                   set cbt-bit  to ascender-bit  (bar-number)
                   if bit-value (cbt-char, cbt-bit) = 0
                       move "D" to bar-code (i:1)     *> descender only
                   else
                       move "F" to bar-code (i:1)      *> both
                   end-if 
               end-if
           end-perform

           exit program.


       error-exit.
           move all "E: " to bar-code.
           exit program.


       confirm-input-argument-lengths.
           if barcode-identifier-length not = 2
               display "Incorrect length on 'barcode-identifier'."
               set argument-error-occurred to true
           else
               if not is-valid-barcode-identifier
                  display "Incorrect value for 'barcode-identifier'."
                  set argument-error-occurred to true
               end-if
           end-if.
           if service-type-identifier-length not = 3
               display "Incorrect length on 'service-type-identifier'."
               set argument-error-occurred to true
           end-if.
           if  mailer-identifier-length not = 6
           and mailer-identifier-length not = 9
               display "Incorrect length on 'mailer-identifier'."
               set argument-error-occurred to true
           end-if.
           if  serial-number-length not = 6
           and serial-number-length not = 9
               display "Incorrect length on 'serial-number'."
               set argument-error-occurred to true
           end-if.
           if  ZIP-code-length not = 0
           and ZIP-code-length not = 5
           and ZIP-code-length not = 9
           and ZIP-code-length not = 11
               display "Incorrect length on 'delivery-point-ZIP-code'."
               set argument-error-occurred to true
           end-if.
           if  (mailer-identifier-length = 6
           and serial-number-length not = 9)
           or  (mailer-identifier-length = 9
           and serial-number-length not = 6)
               display "Lengths on 'mailer-identifier' and 'serial-number' disagree."
               set argument-error-occurred to true
           end-if.
           
       confirm-input-arguments-numeric.
           if barcode-identifier-length = 2
               if barcode-identifier not numeric
                   display "Nonnumeric value in 'barcode-identifier'."
                   set argument-error-occurred to true
               end-if
           end-if.
           if service-type-identifier-length = 3
               if barcode-identifier not numeric
                   display "Nonnumeric value in 'service-type-identifier'."
                   set argument-error-occurred to true
               end-if
           end-if.
           if  mailer-identifier-length = 6
           or  mailer-identifier-length = 9
               if mailer-identifier (1: mailer-identifier-length) not numeric
                   display "Nonnumeric value in 'mailer-identifier'."
                   set argument-error-occurred to true
               end-if
           end-if.
           if  serial-number-length = 6
           or  serial-number-length = 9
               if serial-number (1: serial-number-length) not numeric
                   display "Nonnumeric value in 'serial-number'."
                   set argument-error-occurred to true
               end-if
           end-if.
           if  ZIP-code-length = 5
           or  ZIP-code-length = 9
           or  ZIP-code-length = 11
               if delivery-point-ZIP-code (1: ZIP-code-length) not numeric
                   display "Nonnumeric value in 'delivery-point-ZIP-code'."
                   set argument-error-occurred to true
               end-if
           end-if.
           
       decode-input-arguments.
           initialize argument-lengths to default.
           CALL "C$CARG" USING C-CARG-SUCCESS,
                               barcode-identifier
                               Argument-Description.
           if not is-c-carg-success
               display "Error decoding 'barcode-identifier'."
               set argument-error-occurred to true
           end-if.
           if ARGUMENT-IS-OMITTED
               display "'barcode-identifier' may not be omitted."
               set argument-error-occurred to true
           else    
               move Argument-length to barcode-identifier-length
           end-if.
           CALL "C$CARG" USING C-CARG-SUCCESS,
                               service-type-identifier
                               Argument-Description.
           if not is-c-carg-success
               display "Error decoding 'service-type-identifier'."
               set argument-error-occurred to true
           end-if.
           if ARGUMENT-IS-OMITTED
               display "'service-type-identifier' may not be omitted."
               set argument-error-occurred to true
           else    
               move Argument-length to service-type-identifier-length
           end-if.
           CALL "C$CARG" USING C-CARG-SUCCESS,
                               mailer-identifier
                               Argument-Description.
           if not is-c-carg-success
               display "Error decoding 'mailer-identifier'."
               set argument-error-occurred to true
           end-if.
           if ARGUMENT-IS-OMITTED
               display "'mailer-identifier' may not be omitted."
               set argument-error-occurred to true
           else    
               move Argument-length to mailer-identifier-length
           end-if.
           CALL "C$CARG" USING C-CARG-SUCCESS,
                               serial-number
                               Argument-Description.
           if not is-c-carg-success
               display "Error decoding 'serial-number'."
               set argument-error-occurred to true
           end-if.
           if ARGUMENT-IS-OMITTED
               display "'serial-number' may not be omitted."
               set argument-error-occurred to true
           else    
               move Argument-length to serial-number-length
           end-if.
           CALL "C$CARG" USING C-CARG-SUCCESS,
                               delivery-point-ZIP-code
                               Argument-Description.
           if not is-c-carg-success
               display "Error decoding 'delivery-point-ZIP-code'."
               set argument-error-occurred to true
           end-if.
           if not ARGUMENT-IS-OMITTED
               move Argument-length to ZIP-code-length.


       identification division.
       program-id.  "USPS_MSB_Math_CRC11GenerateFCS".
       data division.
       working-storage section.
       01  msg-length          pic 9(9) binary.
       01  i                   pic 9(9) binary.
       01  j                   pic 9(9) binary.
       01  k                   pic 9(9) binary.
       01  bit                 pic 9(9) binary.
       01  hex-display         pic x(16) value "0123456789ABCDEF".

       01  crc11-accum         pic 9(5) binary(2).
       01  redefines crc11-accum.
           02  crc11-upper     pic 9(3) binary(1).
           02  crc11-lower     pic 9(3) binary(1).
       01  current-octet       pic 9(5) binary(2).

       01  xor11-a             pic 9(5) binary(2).
       01  xor11-b             pic 9(5) binary(2).
       01  temp-c              pic x.
       
       01  initial-shift       pic 9 binary(1).    
       01  initial-bit         pic 9 binary(1).

       01  generator-polynomial pic 9(5) binary(2) value 3893.
       01  constant-07ff        pic 9(5) binary(2) value 2047.

       linkage section.
       01  message-buffer.
           02  message-octet   pic 999 binary(1) occurs 13.

       01  crc11               pic 9(5) binary(2).

       procedure division using message-buffer giving crc11.
       a.
           move constant-07ff to crc11-accum.   *> x"07ff"
           move 5    to initial-shift.
           move 2    to initial-bit.
           move length of message-buffer to msg-length.
           perform varying i from 1 by 1 until i > msg-length
      D        *> display "Beginning of iteration " 
      D        *>         i size 1 convert ": "
      D        *> perform display-crc11
               move message-octet (i) to current-octet
               call "C$LogicalShiftLeft" using current-octet, initial-shift
               perform varying bit from initial-bit by 1
                         until bit not < 8
                   call "C$LogicalXor" giving xor11-a
                                       using crc11-accum
                                                current-octet
                   call "C$LogicalAnd" giving xor11-b
                                          using xor11-a, 1024
                   call "C$LogicalShiftLeft" using crc11-accum
                   if xor11-b not = 0
                       call "C$LogicalXor" using crc11-accum
                                                 generator-polynomial
                   
                   end-if     
                   call "C$LogicalAnd" using crc11-accum
                                                constant-07ff
                   call "C$LogicalShiftLeft" using current-octet
               end-perform
               move 3 to initial-shift
               move 0 to initial-bit
           end-perform.
      D    perform display-crc11.
           move crc11-accum to crc11.
           exit program.          

       display-crc11.
           display " CRC11 = ".
           call "DisplayHex" using crc11-accum, "XXXX".

       end program "USPS_MSB_Math_CRC11GenerateFCS".

       identification division.
       program-id.  "DisplayHex" common.
       data division.
       working-storage section.
       01  ARGUMENT-DESCRIPTION        BINARY(2).
           02  ARGUMENT-TYPE           PIC 9(2).
               88  ARGUMENT-IS-OMITTED VALUE 32.
           02  ARGUMENT-LENGTH         PIC 9(8) BINARY(4).
           02  ARGUMENT-DIGIT-COUNT    PIC 9(2).
           02  ARGUMENT-SCALE          PIC S9(2).

       01  C-CARG-SUCCESS              PIC X.
           88  IS-C-CARG-SUCCESS       VALUE "Y".

       01  msg-length          pic 9(9) binary.
       01  space-interval      pic S999 binary.
       01  space-countdown     pic S999 binary.
       01  i                   pic 9(9) binary.
       01  j                   pic 9(9) binary.
       01  k                   pic 9(9) binary.
       01  octet               pic 999 binary(1).
       01  hex-display         pic x(16) value "0123456789ABCDEF".

       linkage section.
       01  message-buffer      pic x(40).

       01  length-indicator    pic x(1000).


       procedure division using message-buffer, length-indicator.
       a.
           CALL "C$CARG" USING C-CARG-SUCCESS,
                               message-buffer
                               Argument-Description.
           if not is-c-carg-success
               display "Error decoding 'message-buffer'."
               stop run
           end-if.
           move Argument-length to msg-length
           CALL "C$CARG" USING C-CARG-SUCCESS,
                               length-indicator
                               Argument-Description.
           if not is-c-carg-success
               display "Error decoding 'length-indicator'."
               stop run
           end-if.
           if ARGUMENT-IS-OMITTED
               move 999 to space-interval
           else    
               move Argument-length to space-interval
           end-if.
           move space-interval to space-countdown
           perform varying i from 1 by 1 until i > msg-length
              move message-buffer (i:1) to octet(1:1)
              divide 16 into octet giving j remainder k
              add 1 to j
              add 1 to k
              display hex-display (j:1) position 0
                      hex-display (k:1) position 0
               subtract 2 from space-countdown
               if space-countdown < 1
                  display " " position 0
                  move space-interval to space-countdown
               end-if
           end-perform    
           .
       end program "DisplayHex".
       end program "EncodeUSPSBarcode".
